#include <bits/stdc++.h>
using namespace std;

struct Point {
    long long x, y;
};

long long cross(const Point& O, const Point& A, const Point& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Point> convexHull(vector<Point>& P) {
    int n = P.size(), k = 0;
    if (n == 1) return P;
    vector<Point> H(2 * n);

    sort(P.begin(), P.end(), [](Point a, Point b) {
        return a.x < b.x || (a.x == b.x && a.y < b.y);
    });

    for (int i = 0; i < n; ++i) {
        while (k >= 2 && cross(H[k - 2], H[k - 1], P[i]) <= 0) k--;
        H[k++] = P[i];
    }
    for (int i = n - 2, t = k + 1; i >= 0; --i) {
        while (k >= t && cross(H[k - 2], H[k - 1], P[i]) <= 0) k--;
        H[k++] = P[i];
    }
    H.resize(k - 1);
    return H;
}

long long area(const vector<Point>& H) {
    long long A = 0;
    int n = H.size();
    for (int i = 0; i < n; ++i) {
        A += H[i].x * H[(i + 1) % n].y - H[i].y * H[(i + 1) % n].x;
    }
    return abs(A) / 2;
}

int main() {
    int N;
    cin >> N;
    vector<Point> points(N);
    for (int i = 0; i < N; i++) {
        cin >> points[i].x >> points[i].y;
    }

    if (N == 4) {
        long long min_area = LLONG_MAX;
        for (int i = 0; i < N; i++) {
            vector<Point> subset;
            for (int j = 0; j < N; j++) {
                if (i != j) subset.push_back(points[j]);
            }
            vector<Point> hull = convexHull(subset);
            min_area = min(min_area, area(hull));
        }
        cout << min_area << endl;
    } else if (N > 4) {
        vector<Point> hull = convexHull(points);
        cout << area(hull) << endl;
    }

    return 0;
}